# 🚀 InvoicePro Deployment Guide

## 📋 Pre-Deployment Checklist

### ✅ Application Status
- [x] Production build completed
- [x] Assets compiled and minified
- [x] Dependencies optimized
- [x] Configuration cached
- [x] Routes cached
- [x] Views cached

### 📁 Files Ready for Upload
Upload the entire `empower/` directory to your cPanel hosting.

## 🌐 Domain Configuration

**Subdomain:** `https://smartinvoice.sspnetworks.co.ke`

## ⚙️ cPanel Setup Steps

### 1. Upload Files
- Upload all project files to your hosting directory
- Set `public/` as the document root

### 2. Database Already Created
- ✅ Database: `uccxbsjz_empower`
- ✅ User: `uccxbsjz_kirika`
- ✅ Password: `kirika@2025`
- ✅ All privileges granted

### 3. Configure Environment
Create `.env` file in root directory with:

```env
APP_NAME="InvoicePro"
APP_ENV=production
APP_KEY=base64:+g+TjZ1gpDD2zpOOEIh/SPfvgMudAohBD7AT+cR4Z9Q=
APP_DEBUG=false
APP_TIMEZONE=Africa/Nairobi
APP_URL=https://smartinvoice.sspnetworks.co.ke

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=uccxbsjz_empower
DB_USERNAME=uccxbsjz_kirika
DB_PASSWORD=kirika@2025

# M-Pesa Configuration (Get from Safaricom)
MPESA_CONSUMER_KEY=your_consumer_key
MPESA_CONSUMER_SECRET=your_consumer_secret
MPESA_SHORTCODE=your_shortcode
MPESA_PASSKEY=your_passkey
MPESA_ENVIRONMENT=production
```

### 4. Run Deployment Commands
Execute these via SSH/cPanel Terminal:

```bash
cd /home/your_cpanel_user/public_html
php artisan migrate --force
php artisan storage:link
php artisan optimize:clear
php artisan optimize
```

### 5. Set File Permissions
```bash
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
```

## 🔧 Post-Deployment Configuration

### SSL Certificate
- Install SSL certificate for HTTPS
- Required for M-Pesa integration

### M-Pesa Setup
1. Register for M-Pesa API access
2. Get production credentials
3. Update `.env` with real credentials
4. Configure callback URLs:
   - Validation: `https://smartinvoice.sspnetworks.co.ke/payments/callback`
   - Confirmation: `https://smartinvoice.sspnetworks.co.ke/payments/callback`

### Cron Jobs (Optional)
Set up for automated tasks:
```bash
* * * * * cd /home/your_cpanel_user/public_html && php artisan schedule:run >> /dev/null 2>&1
```

## 🧪 Testing Checklist

- [ ] Homepage loads: `https://smartinvoice.sspnetworks.co.ke`
- [ ] Create invoice page works
- [ ] Dashboard accessible
- [ ] PDF generation works
- [ ] Payment links generate
- [ ] Database connections work
- [ ] File uploads work

## 🚨 Important Notes

1. **Security**: Never commit `.env` to version control
2. **Backups**: Set up regular database backups
3. **Monitoring**: Monitor error logs in `storage/logs/`
4. **Updates**: Keep Laravel and dependencies updated
5. **SSL**: Always use HTTPS in production

## 📞 Support

If you encounter issues:
1. Check Laravel logs: `storage/logs/laravel.log`
2. Verify file permissions
3. Confirm database credentials
4. Test M-Pesa configuration

---

**Generated Application Key:** `base64:+g+TjZ1gpDD2zpOOEIh/SPfvgMudAohBD7AT+cR4Z9Q=`

**Deployment Date:** Ready for immediate deployment
