# TODO: Prepare Project for cPanel Upload

## Overview
Prepare the Laravel InvoicePro project for production deployment to cPanel by running build commands, caching, setting permissions, and cleaning up unnecessary files.

## Steps to Complete

### 1. Build Production Assets
- Run `npm run build` to compile and minify CSS/JS assets.

### 2. Cache Laravel Configurations
- Run `php artisan config:cache` to cache configuration files.
- Run `php artisan route:cache` to cache routes.
- Run `php artisan view:cache` to cache views.

### 3. Run Database Migrations
- Run `php artisan migrate --force` to ensure database schema is up-to-date (force for production).

### 4. Set File Permissions
- Set permissions for `storage/` and `bootstrap/cache/` to 755.

### 5. Clean Up Development Files
- Remove test files (test_*.php) as they are not needed in production.
- Remove .dist/ directory if present.
- Keep node_modules/ and vendor/ for now, as README says upload entire directory.

### 6. Verify .env Configuration
- Ensure .env is set for production (APP_ENV=production, APP_DEBUG=false, correct DB and M-Pesa configs).

### 7. Test Locally
- Run `php artisan serve` and verify key pages load (dashboard, invoice creation, etc.).

### 8. Prepare for Upload
- Create a zip file of the project, excluding .git/, vendor/, node_modules/ if not uploading dependencies.
- Ready for upload to cPanel with public/ as document root.
