<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function index()
    {
        // Get unique customers from invoices
        $customers = Invoice::select('customer_name', 'contact_email')
            ->selectRaw('COUNT(*) as total_invoices')
            ->selectRaw('SUM(CASE WHEN status = "paid" THEN amount ELSE 0 END) as total_paid')
            ->selectRaw('SUM(CASE WHEN status = "pending" THEN amount ELSE 0 END) as total_pending')
            ->groupBy('customer_name', 'contact_email')
            ->orderBy('total_invoices', 'desc')
            ->get();

        return view('customers.index', compact('customers'));
    }

    public function show($customerName)
    {
        $customerInvoices = Invoice::where('customer_name', $customerName)
            ->with('payments')
            ->orderBy('created_at', 'desc')
            ->get();

        $customerData = [
            'name' => $customerName,
            'email' => $customerInvoices->first()->contact_email ?? null,
            'total_invoices' => $customerInvoices->count(),
            'total_paid' => $customerInvoices->where('status', 'paid')->sum('amount'),
            'total_pending' => $customerInvoices->where('status', 'pending')->sum('amount'),
            'invoices' => $customerInvoices
        ];

        return view('customers.show', compact('customerData'));
    }
}
