<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Invoice extends Model
{
    protected $fillable = [
        'business_name',
        'customer_name',
        'description',
        'amount',
        'contact_email',
        'notes',
        'due_date',
        'status',
        'invoice_number',
        'token',
        'items',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'due_date' => 'date',
        'items' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($invoice) {
            $invoice->invoice_number = 'INV-' . strtoupper(Str::random(8));
            $invoice->token = Str::random(32);
        });
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function isPaid()
    {
        return $this->status === 'paid';
    }

    public function isExpired()
    {
        return $this->status === 'expired';
    }

    public function markAsPaid()
    {
        $this->update(['status' => 'paid']);
    }

    public function markAsExpired()
    {
        $this->update(['status' => 'expired']);
    }
}
