<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $fillable = [
        'invoice_id',
        'merchant_request_id',
        'transaction_id',
        'phone_number',
        'amount',
        'status',
        'callback_data',
        'paid_at',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'callback_data' => 'array',
        'paid_at' => 'datetime',
    ];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function isSuccessful()
    {
        return $this->status === 'successful';
    }
}
