<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('business_name');
            $table->string('customer_name');
            $table->string('description');
            $table->decimal('amount', 10, 2);
            $table->string('contact_email')->nullable();
            $table->text('notes')->nullable();
            $table->date('due_date')->nullable();
            $table->string('status')->default('pending'); // pending, paid, cancelled, expired
            $table->string('invoice_number')->unique();
            $table->string('token')->unique(); // for unique link
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
