<?php

namespace Database\Seeders;

use App\Models\Invoice;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class InvoiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Invoice::create([
            'business_name' => 'Tech Solutions Ltd',
            'customer_name' => 'John Doe',
            'description' => 'Website Development Services',
            'amount' => 50000.00,
            'contact_email' => 'john@example.com',
            'notes' => 'Payment for complete website development project',
            'due_date' => now()->addDays(30),
            'status' => 'pending',
            'created_at' => now()->subMonths(1), // November
        ]);

        Invoice::create([
            'business_name' => 'Tech Solutions Ltd',
            'customer_name' => 'Jane Smith',
            'description' => 'Mobile App Development',
            'amount' => 75000.00,
            'contact_email' => 'jane@example.com',
            'notes' => 'iOS and Android app development',
            'due_date' => now()->addDays(45),
            'status' => 'paid',
            'created_at' => now(), // November
        ]);

        Invoice::create([
            'business_name' => 'Tech Solutions Ltd',
            'customer_name' => 'Bob Johnson',
            'description' => 'SEO Services',
            'amount' => 25000.00,
            'contact_email' => 'bob@example.com',
            'notes' => 'Search engine optimization for 6 months',
            'due_date' => now()->addDays(15),
            'status' => 'cancelled',
            'created_at' => now(), // November
        ]);

        Invoice::create([
            'business_name' => 'Tech Solutions Ltd',
            'customer_name' => 'Alice Brown',
            'description' => 'Consulting Services',
            'amount' => 30000.00,
            'contact_email' => 'alice@example.com',
            'notes' => 'Technical consulting for 20 hours',
            'due_date' => now()->addDays(20),
            'status' => 'pending',
            'created_at' => now(), // Current month
        ]);

        Invoice::create([
            'business_name' => 'Tech Solutions Ltd',
            'customer_name' => 'Charlie Wilson',
            'description' => 'Database Design',
            'amount' => 40000.00,
            'contact_email' => 'charlie@example.com',
            'notes' => 'Complete database architecture and implementation',
            'due_date' => now()->addDays(25),
            'status' => 'paid',
            'created_at' => now(), // Current month
        ]);
    }
}
