@extends('layouts.app')

@section('content')
<div class="px-4 py-6 sm:px-0">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-900 mb-2">Analytics Dashboard</h1>
            <p class="text-gray-600">Detailed insights into your invoice and payment performance</p>
        </div>
        <a href="{{ route('dashboard') }}" class="bg-gray-100 text-gray-700 px-6 py-3 rounded-xl hover:bg-gray-200 flex items-center font-semibold transition-all duration-200">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <!-- Key Metrics -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-blue-100 text-sm font-medium">Total Invoices</p>
                    <p class="text-3xl font-bold">{{ $analytics['total_invoices'] }}</p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-file-invoice text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-gradient-to-r from-green-500 to-green-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-green-100 text-sm font-medium">Paid Invoices</p>
                    <p class="text-3xl font-bold">{{ $analytics['paid_invoices'] }}</p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-check-circle text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-gradient-to-r from-yellow-500 to-yellow-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-yellow-100 text-sm font-medium">Pending Invoices</p>
                    <p class="text-3xl font-bold">{{ $analytics['pending_invoices'] }}</p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-clock text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-gradient-to-r from-purple-500 to-purple-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-purple-100 text-sm font-medium">Success Rate</p>
                    <p class="text-3xl font-bold">{{ $analytics['success_rate'] }}%</p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-chart-line text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Financial Summary -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 card-hover">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-money-bill-wave mr-2 text-green-600"></i>Financial Summary
                </h3>
            </div>
            <div class="p-6 space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-gray-600">Total Amount</span>
                    <span class="font-semibold text-gray-900">Ksh {{ number_format($analytics['total_amount'], 2) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-gray-600">Paid Amount</span>
                    <span class="font-semibold text-green-600">Ksh {{ number_format($analytics['paid_amount'], 2) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-gray-600">Pending Amount</span>
                    <span class="font-semibold text-yellow-600">Ksh {{ number_format($analytics['pending_amount'], 2) }}</span>
                </div>
                <div class="border-t pt-4">
                    <div class="flex justify-between items-center">
                        <span class="font-medium text-gray-900">Outstanding</span>
                        <span class="font-bold text-lg text-red-600">Ksh {{ number_format($analytics['pending_amount'], 2) }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Invoice Status Distribution -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 card-hover">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-chart-pie mr-2 text-indigo-600"></i>Status Distribution
                </h3>
            </div>
            <div class="p-6">
                <div class="space-y-3">
                    <div class="flex justify-between items-center">
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-green-500 rounded mr-3"></div>
                            <span class="text-sm text-gray-600">Paid</span>
                        </div>
                        <span class="font-semibold">{{ $analytics['paid_invoices'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-yellow-500 rounded mr-3"></div>
                            <span class="text-sm text-gray-600">Pending</span>
                        </div>
                        <span class="font-semibold">{{ $analytics['pending_invoices'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-red-500 rounded mr-3"></div>
                            <span class="text-sm text-gray-600">Cancelled</span>
                        </div>
                        <span class="font-semibold">{{ $analytics['cancelled_invoices'] }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 card-hover">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-bolt mr-2 text-purple-600"></i>Performance Metrics
                </h3>
            </div>
            <div class="p-6 space-y-4">
                <div class="text-center">
                    <div class="text-3xl font-bold text-purple-600 mb-1">{{ $analytics['success_rate'] }}%</div>
                    <div class="text-sm text-gray-600">Payment Success Rate</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold text-blue-600 mb-1">{{ $analytics['total_invoices'] }}</div>
                    <div class="text-sm text-gray-600">Total Transactions</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold text-green-600 mb-1">Ksh {{ number_format($analytics['paid_amount'], 0) }}</div>
                    <div class="text-sm text-gray-600">Revenue Generated</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Export Section -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 card-hover">
        <div class="px-6 py-5 border-b border-gray-200">
            <h3 class="text-xl leading-6 font-semibold text-gray-900 flex items-center">
                <i class="fas fa-download mr-3 text-green-600"></i>Export Data
            </h3>
        </div>
        <div class="p-6">
            <p class="text-gray-600 mb-4">Download your invoice and payment data in PDF format for external analysis or record keeping.</p>
            <a href="{{ route('dashboard.export') }}" class="btn-primary text-white px-6 py-3 rounded-lg hover:shadow-lg flex items-center font-semibold transition-all duration-200">
                <i class="fas fa-download mr-2"></i>Export to PDF
            </a>
        </div>
    </div>
</div>
@endsection
