@extends('layouts.app')

@section('content')
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover">
        <div class="bg-gradient-to-r from-indigo-600 to-purple-600 px-8 py-6">
            <div class="flex items-center">
                <div class="bg-white bg-opacity-20 p-3 rounded-xl">
                    <i class="fas fa-file-invoice text-white text-2xl"></i>
                </div>
                <div class="ml-4">
                    <h1 class="text-2xl font-bold text-white">Create New Invoice</h1>
                    <p class="text-indigo-100 mt-1">Fill in the details to generate a professional invoice</p>
                </div>
            </div>
        </div>

        <form method="POST" action="{{ route('invoices.store') }}" class="p-8">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="md:col-span-2">
                    <label for="business_name" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                        <i class="fas fa-building mr-2 text-indigo-600"></i>Business Name
                    </label>
                    <input type="text" name="business_name" id="business_name" value="{{ old('business_name') }}" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all duration-200"
                           placeholder="Enter your business name">
                    @error('business_name')
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="customer_name" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                        <i class="fas fa-user mr-2 text-indigo-600"></i>Customer Name
                    </label>
                    <input type="text" name="customer_name" id="customer_name" value="{{ old('customer_name') }}" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all duration-200"
                           placeholder="Customer full name">
                    @error('customer_name')
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="contact_email" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                        <i class="fas fa-envelope mr-2 text-indigo-600"></i>Contact Email (Optional)
                    </label>
                    <input type="email" name="contact_email" id="contact_email" value="{{ old('contact_email') }}"
                           class="w-full px-4 py-3 border border-gray-300 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all duration-200"
                           placeholder="customer@example.com">
                    @error('contact_email')
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                    @enderror
                </div>

                <div class="md:col-span-2">
                    <label for="description" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                        <i class="fas fa-file-alt mr-2 text-indigo-600"></i>Payment Reference / Description
                    </label>
                    <input type="text" name="description" id="description" value="{{ old('description') }}" required
                           class="w-full px-4 py-3 border border-gray-300 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all duration-200"
                           placeholder="What is this payment for?">
                    @error('description')
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                    @enderror
                </div>

                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-4 flex items-center">
                        <i class="fas fa-list mr-2 text-indigo-600"></i>Invoice Items
                    </label>

                    <div id="items-container">
                        <!-- Default item row -->
                        <div class="item-row flex gap-4 mb-4 p-4 bg-gray-50 rounded-xl">
                            <div class="w-32">
                                <label class="block text-xs font-medium text-gray-600 mb-1">Item Name</label>
                                <input type="text" name="items[0][name]" class="item-name w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                       placeholder="Item description">
                                @error('items.0.name')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="w-32">
                                <label class="block text-xs font-medium text-gray-600 mb-1">Qty</label>
                                <input type="number" min="1" name="items[0][quantity]" class="item-quantity w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                       placeholder="1" value="1">
                                @error('items.0.quantity')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="w-32">
                                <label class="block text-xs font-medium text-gray-600 mb-1">Price (Ksh)</label>
                                <input type="number" step="0.01" min="0" name="items[0][price]" class="item-price w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                       placeholder="0.00">
                                @error('items.0.price')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="flex items-end">
                                <button type="button" class="remove-item bg-red-500 text-white px-3 py-2 rounded-lg hover:bg-red-600 transition-colors" style="display: none;">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <button type="button" id="add-item" class="mt-4 btn btn-primary">
                        <i class="fas fa-plus mr-2"></i>Add Item
                    </button>
                </div>

                <div>
                    <label for="amount" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                        <i class="fas fa-money-bill-wave mr-2 text-green-600"></i>Total Amount (Ksh)
                    </label>
                    <div class="relative">
                        <span class="absolute left-4 top-3 text-gray-500 font-medium">Ksh</span>
                        <input type="number" step="0.01" name="amount" id="amount" value="{{ old('amount') }}" required readonly
                               class="w-full pl-16 pr-4 py-3 border border-gray-300 rounded-xl shadow-sm bg-gray-50 text-gray-700 font-medium focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all duration-200"
                               placeholder="0.00">
                    </div>
                    @error('amount')
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="due_date" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                        <i class="fas fa-calendar mr-2 text-indigo-600"></i>Due Date (Optional)
                    </label>
                    <input type="date" name="due_date" id="due_date" value="{{ old('due_date') }}"
                           class="w-full px-4 py-3 border border-gray-300 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all duration-200">
                    @error('due_date')
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                    @enderror
                </div>

                <div class="md:col-span-2">
                    <label for="notes" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                        <i class="fas fa-sticky-note mr-2 text-indigo-600"></i>Notes (Optional)
                    </label>
                    <textarea name="notes" id="notes" rows="4"
                              class="w-full px-4 py-3 border border-gray-300 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-all duration-200 resize-none"
                              placeholder="Any additional notes or terms...">{{ old('notes') }}</textarea>
                    @error('notes')
                        <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="flex items-center justify-between mt-8 pt-6 border-t border-gray-200">
                <a href="{{ route('dashboard') }}" class="btn-danger text-white px-6 py-3 rounded-xl hover:shadow-lg flex items-center font-semibold transition-all duration-200">
                    <i class="fas fa-times mr-2"></i>Cancel
                </a>
                <button type="submit" class="btn-primary text-white px-8 py-3 rounded-xl hover:shadow-xl flex items-center font-semibold transition-all duration-200">
                    <i class="fas fa-plus mr-2"></i>Create Invoice
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    let itemIndex = 1;

    // Function to calculate row total (removed since we don't have row totals anymore)
    function calculateRowTotal(row) {
        const quantity = parseFloat(row.querySelector('.item-quantity').value) || 0;
        const price = parseFloat(row.querySelector('.item-price').value) || 0;
        const total = quantity * price;
        return total;
    }

    // Function to calculate grand total
    function calculateGrandTotal() {
        let grandTotal = 0;
        document.querySelectorAll('.item-row').forEach(row => {
            grandTotal += calculateRowTotal(row);
        });
        document.getElementById('amount').value = grandTotal.toFixed(2);
    }

    // Function to update remove buttons visibility
    function updateRemoveButtons() {
        const rows = document.querySelectorAll('.item-row');
        rows.forEach(row => {
            const removeBtn = row.querySelector('.remove-item');
            if (rows.length > 1) {
                removeBtn.style.display = 'block';
            } else {
                removeBtn.style.display = 'none';
            }
        });
    }

    // Function to create new item row
    function createItemRow(index) {
        const row = document.createElement('div');
        row.className = 'item-row flex gap-4 mb-4 p-4 bg-gray-50 rounded-xl';
        row.innerHTML = `
            <div class="w-32">
                <label class="block text-xs font-medium text-gray-600 mb-1">Item Name</label>
                <input type="text" name="items[${index}][name]" class="item-name w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                       placeholder="Item description">
            </div>
            <div class="w-32">
                <label class="block text-xs font-medium text-gray-600 mb-1">Qty</label>
                <input type="number" min="1" name="items[${index}][quantity]" class="item-quantity w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                       placeholder="1" value="1">
            </div>
            <div class="w-32">
                <label class="block text-xs font-medium text-gray-600 mb-1">Price (Ksh)</label>
                <input type="number" step="0.01" min="0" name="items[${index}][price]" class="item-price w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                       placeholder="0.00">
            </div>
            <div class="flex items-end">
                <button type="button" class="remove-item bg-red-500 text-white px-3 py-2 rounded-lg hover:bg-red-600 transition-colors">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        `;

        // Add event listeners to new row inputs
        row.querySelector('.item-quantity').addEventListener('input', calculateGrandTotal);
        row.querySelector('.item-price').addEventListener('input', calculateGrandTotal);
        row.querySelector('.remove-item').addEventListener('click', function() {
            row.remove();
            updateRemoveButtons();
            calculateGrandTotal();
        });

        return row;
    }

    // Add item button event
    const addItemBtn = document.getElementById('add-item');
    if (addItemBtn) {
        addItemBtn.addEventListener('click', function() {
            const container = document.getElementById('items-container');
            if (container) {
                const newRow = createItemRow(itemIndex++);
                container.appendChild(newRow);
                updateRemoveButtons();
                calculateGrandTotal();
            }
        });
    }

    // Initial setup
    document.querySelectorAll('.item-quantity, .item-price').forEach(input => {
        input.addEventListener('input', calculateGrandTotal);
    });

    document.querySelectorAll('.remove-item').forEach(btn => {
        btn.addEventListener('click', function() {
            this.closest('.item-row').remove();
            updateRemoveButtons();
            calculateGrandTotal();
        });
    });

    // Initial calculations
    calculateGrandTotal();
    updateRemoveButtons();
});
</script>
@endsection
