<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .invoice-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .invoice-number {
            font-size: 18px;
            color: #666;
        }
        .invoice-details {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        .detail-section {
            width: 45%;
        }
        .detail-section h3 {
            margin-bottom: 10px;
            font-size: 16px;
            color: #555;
        }
        .detail-section p {
            margin: 5px 0;
            font-size: 14px;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        .items-table th,
        .items-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        .items-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .total-section {
            text-align: right;
            margin-bottom: 30px;
        }
        .total-amount {
            font-size: 20px;
            font-weight: bold;
            color: #007bff;
        }
        .notes {
            margin-top: 30px;
            padding: 15px;
            background-color: #f9f9f9;
            border-left: 4px solid #007bff;
        }
        .notes h4 {
            margin-bottom: 10px;
            color: #007bff;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 class="invoice-title">{{ $invoice->business_name }}</h1>
        <p class="invoice-number">Invoice #{{ $invoice->invoice_number }}</p>
    </div>

    <div class="invoice-details">
        <div class="detail-section">
            <h3>Bill To:</h3>
            <p><strong>{{ $invoice->customer_name }}</strong></p>
            @if($invoice->contact_email)
                <p>{{ $invoice->contact_email }}</p>
            @endif
        </div>
        <div class="detail-section">
            <h3>Invoice Details:</h3>
            <p><strong>Date:</strong> {{ $invoice->created_at->format('M d, Y') }}</p>
            @if($invoice->due_date)
                <p><strong>Due Date:</strong> {{ $invoice->due_date->format('M d, Y') }}</p>
            @endif
            <p><strong>Status:</strong> {{ ucfirst($invoice->status) }}</p>
        </div>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th>Description</th>
                <th>Quantity</th>
                <th>Unit Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @php
                $items = json_decode($invoice->items, true);
            @endphp
            @if(is_array($items))
                @foreach($items as $item)
                    <tr>
                        <td>{{ $item['name'] }}</td>
                        <td>{{ $item['quantity'] }}</td>
                        <td>Ksh {{ number_format($item['price'], 2) }}</td>
                        <td>Ksh {{ number_format($item['quantity'] * $item['price'], 2) }}</td>
                    </tr>
                @endforeach
            @endif
        </tbody>
    </table>

    <div class="total-section">
        <p><strong>Total Amount: <span class="total-amount">Ksh {{ number_format($invoice->amount, 2) }}</span></strong></p>
    </div>

    @if($invoice->status == 'pending')
    <div class="payment-section" style="text-align: center; margin: 30px 0; padding: 20px; background-color: #e8f4fd; border: 1px solid #007bff; border-radius: 5px;">
        <h4 style="color: #007bff; margin-bottom: 10px;">Payment Required</h4>
        <p style="margin-bottom: 15px; color: #333;">Click the link below to make your payment securely via M-Pesa:</p>
        <p style="font-size: 16px; font-weight: bold; color: #007bff;">{{ route('payments.pay', [$invoice, $invoice->token]) }}</p>
    </div>
    @endif

    @if($invoice->description)
        <div class="notes">
            <h4>Description:</h4>
            <p>{{ $invoice->description }}</p>
        </div>
    @endif

    @if($invoice->notes)
        <div class="notes">
            <h4>Notes:</h4>
            <p>{{ $invoice->notes }}</p>
        </div>
    @endif

    <div class="footer">
        <p>Thank you for your business!</p>
        <p>Generated on {{ now()->format('M d, Y \a\t H:i:s') }}</p>
    </div>
</body>
</html>
