@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto">
    <!-- Invoice Header -->
    <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover mb-6">
        <div class="bg-gradient-to-r from-indigo-600 to-purple-600 px-8 py-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="bg-white bg-opacity-20 p-3 rounded-xl">
                        <i class="fas fa-file-invoice text-white text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <h1 class="text-2xl font-bold text-white">Invoice Details</h1>
                        <p class="text-indigo-100 mt-1">Invoice #{{ $invoice->invoice_number }}</p>
                    </div>
                </div>
                <div class="text-right">
                    <span class="status-badge px-4 py-2 inline-flex text-sm leading-5 font-semibold rounded-full
                        @if($invoice->status == 'pending') bg-yellow-100 text-yellow-800 border border-yellow-200
                        @elseif($invoice->status == 'paid') bg-green-100 text-green-800 border border-green-200
                        @elseif($invoice->status == 'cancelled') bg-red-100 text-red-800 border border-red-200
                        @else bg-gray-100 text-gray-800 border border-gray-200 @endif">
                        <i class="fas @if($invoice->status == 'pending') fa-clock @elseif($invoice->status == 'paid') fa-check-circle @elseif($invoice->status == 'cancelled') fa-times-circle @else fa-question-circle @endif mr-2"></i>
                        {{ ucfirst($invoice->status) }}
                    </span>
                </div>
            </div>
        </div>

        <div class="p-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Business & Customer Info -->
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-building mr-2 text-indigo-600"></i>Business Information
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4">
                            <p class="text-sm text-gray-600">Business Name</p>
                            <p class="text-lg font-semibold text-gray-900">{{ $invoice->business_name }}</p>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-user mr-2 text-indigo-600"></i>Customer Information
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4 space-y-3">
                            <div>
                                <p class="text-sm text-gray-600">Customer Name</p>
                                <p class="text-lg font-semibold text-gray-900">{{ $invoice->customer_name }}</p>
                            </div>
                            @if($invoice->contact_email)
                            <div>
                                <p class="text-sm text-gray-600">Contact Email</p>
                                <p class="text-gray-900">{{ $invoice->contact_email }}</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Payment Details -->
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-money-bill-wave mr-2 text-green-600"></i>Payment Details
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4 space-y-4">
                            <div>
                                <p class="text-sm text-gray-600">Description</p>
                                <p class="text-gray-900 font-medium">{{ $invoice->description }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Amount</p>
                                <p class="text-3xl font-bold text-green-600">Ksh {{ number_format($invoice->amount, 2) }}</p>
                            </div>
                            @if($invoice->due_date)
                            <div>
                                <p class="text-sm text-gray-600">Due Date</p>
                                <p class="text-gray-900">{{ $invoice->due_date->format('M d, Y') }}</p>
                            </div>
                            @endif
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-calendar mr-2 text-indigo-600"></i>Timeline
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4">
                            <div class="flex items-center text-sm text-gray-600 mb-2">
                                <i class="fas fa-plus-circle mr-2 text-green-500"></i>
                                Created: {{ $invoice->created_at->format('M d, Y H:i') }}
                            </div>
                            @if($invoice->payments->count() > 0)
                            <div class="flex items-center text-sm text-gray-600">
                                <i class="fas fa-credit-card mr-2 text-blue-500"></i>
                                Last Payment: {{ $invoice->payments->last()->paid_at?->format('M d, Y H:i') ?? 'N/A' }}
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            @if($invoice->notes)
            <div class="mt-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-sticky-note mr-2 text-indigo-600"></i>Notes
                </h3>
                <div class="bg-blue-50 border border-blue-200 rounded-xl p-4">
                    <p class="text-gray-700">{{ $invoice->notes }}</p>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- Actions Section -->
    @if($invoice->status == 'pending')
    <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover">
        <div class="px-8 py-6 border-b border-gray-200">
            <h3 class="text-xl leading-6 font-semibold text-gray-900 flex items-center">
                <i class="fas fa-cogs mr-3 text-indigo-600"></i>Available Actions
            </h3>
        </div>
        <div class="p-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <form method="POST" action="{{ route('invoices.generate-link', $invoice) }}">
                    @csrf
                    <button type="submit" class="w-full btn-success text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-link mr-2"></i>Generate Link
                    </button>
                </form>

                <form method="POST" action="{{ route('invoices.cancel', $invoice) }}">
                    @csrf
                    <button type="submit" class="w-full btn-danger text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200"
                            onclick="return confirm('Are you sure you want to cancel this invoice?')">
                        <i class="fas fa-times mr-2"></i>Cancel Invoice
                    </button>
                </form>

                <form method="POST" action="{{ route('invoices.complete', $invoice) }}">
                    @csrf
                    <button type="submit" class="w-full btn-primary text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-check mr-2"></i>Mark as Done
                    </button>
                </form>

                <a href="{{ route('invoices.pdf', $invoice) }}" class="w-full btn-primary text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                    <i class="fas fa-download mr-2"></i>Export PDF
                </a>
            </div>
        </div>
    </div>
    @endif

    <!-- Payment History -->
    @if($invoice->payments->count() > 0)
    <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover mt-6">
        <div class="px-8 py-6 border-b border-gray-200">
            <h3 class="text-xl leading-6 font-semibold text-gray-900 flex items-center">
                <i class="fas fa-history mr-3 text-indigo-600"></i>Payment History
            </h3>
        </div>
        <div class="p-8">
            <div class="space-y-4">
                @foreach($invoice->payments as $payment)
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl">
                    <div class="flex items-center">
                        <div class="bg-{{ $payment->status == 'successful' ? 'green' : 'red' }}-100 p-3 rounded-lg">
                            <i class="fas fa-{{ $payment->status == 'successful' ? 'check-circle' : 'times-circle' }} text-{{ $payment->status == 'successful' ? 'green' : 'red' }}-600"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-semibold text-gray-900">Ksh {{ number_format($payment->amount, 2) }}</p>
                            <p class="text-sm text-gray-600">{{ $payment->phone_number }}</p>
                            @if($payment->transaction_id)
                            <p class="text-xs text-gray-500">Txn: {{ $payment->transaction_id }}</p>
                            @endif
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-sm text-gray-600">{{ $payment->paid_at?->format('M d, Y H:i') ?? 'Pending' }}</p>
                        <span class="px-2 py-1 text-xs font-semibold rounded-full
                            @if($payment->status == 'successful') bg-green-100 text-green-800
                            @elseif($payment->status == 'failed') bg-red-100 text-red-800
                            @else bg-yellow-100 text-yellow-800 @endif">
                            {{ ucfirst($payment->status) }}
                        </span>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif
</div>
@endsection
