<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
<div class="min-h-screen bg-gradient-to-br from-green-50 to-emerald-50 py-12">
    <div class="max-w-2xl mx-auto px-4">
        <!-- Success Card -->
        <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover">
            <div class="bg-gradient-to-r from-green-600 to-emerald-600 px-8 py-8">
                <div class="text-center">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-white bg-opacity-20 rounded-full mb-4">
                        <i class="fas fa-check-circle text-white text-4xl"></i>
                    </div>
                    <h1 class="text-3xl font-bold text-white mb-2">Payment Successful!</h1>
                    <p class="text-green-100">Your payment has been processed successfully</p>
                </div>
            </div>

            <div class="p-8">
                <!-- Payment Details -->
                <div class="bg-green-50 border border-green-200 rounded-xl p-6 mb-8">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-receipt mr-2 text-green-600"></i>Payment Details
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="space-y-4">
                            <div>
                                <p class="text-sm text-gray-600">Transaction ID</p>
                                <p class="font-mono text-lg font-semibold text-gray-900">{{ $payment->transaction_id ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">M-Pesa Receipt Number</p>
                                <p class="font-mono text-lg font-semibold text-gray-900">{{ $payment->receipt_number ?? 'Pending' }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Amount Paid</p>
                                <p class="text-2xl font-bold text-green-600">Ksh {{ number_format($payment->amount, 2) }}</p>
                            </div>
                        </div>
                        <div class="space-y-4">
                            <div>
                                <p class="text-sm text-gray-600">Payment Date</p>
                                <p class="text-lg font-semibold text-gray-900">{{ $payment->paid_at ? $payment->paid_at->format('M d, Y') : now()->format('M d, Y') }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Payment Time</p>
                                <p class="text-lg font-semibold text-gray-900">{{ $payment->paid_at ? $payment->paid_at->format('H:i') : now()->format('H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Invoice Summary -->
                <div class="bg-blue-50 border border-blue-200 rounded-xl p-6 mb-8">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-file-invoice mr-2 text-blue-600"></i>Invoice Summary
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">Invoice Number</p>
                            <p class="font-semibold text-gray-900">{{ $payment->invoice->invoice_number }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Business</p>
                            <p class="font-semibold text-gray-900">{{ $payment->invoice->business_name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Description</p>
                            <p class="font-semibold text-gray-900">{{ $payment->invoice->description }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Status</p>
                            <span class="px-3 py-1 text-sm font-semibold rounded-full bg-green-100 text-green-800">
                                Paid
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="{{ route('dashboard') }}" class="flex-1 btn-primary text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-tachometer-alt mr-2"></i>Back to Dashboard
                    </a>
                    <a href="{{ route('invoices.show', $payment->invoice) }}" class="flex-1 bg-gray-100 text-gray-700 px-6 py-4 rounded-xl hover:bg-gray-200 flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-eye mr-2"></i>View Invoice
                    </a>
                </div>

                <!-- Thank You Message -->
                <div class="mt-8 text-center">
                    <div class="bg-gradient-to-r from-green-100 to-emerald-100 border border-green-200 rounded-xl p-6">
                        <i class="fas fa-heart text-green-600 text-2xl mb-2"></i>
                        <h4 class="text-lg font-semibold text-green-800 mb-2">Thank You!</h4>
                        <p class="text-green-700">Your payment has been successfully processed. You should receive a confirmation SMS from M-Pesa shortly.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Info -->
        <div class="mt-8 bg-white rounded-xl shadow-lg border border-gray-200 p-6">
            <div class="flex items-start">
                <i class="fas fa-info-circle text-blue-600 text-xl mr-3 mt-1"></i>
                <div>
                    <h4 class="text-lg font-semibold text-gray-900 mb-2">What happens next?</h4>
                    <ul class="text-gray-700 space-y-2">
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            You'll receive an M-Pesa confirmation SMS
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            Your invoice status has been updated to "Paid"
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            A receipt has been generated for your records
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
