<?php

use App\Http\Controllers\CustomerController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('dashboard');
});

// Dashboard
Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
Route::get('/dashboard/export', [DashboardController::class, 'export'])->name('dashboard.export');
Route::get('/dashboard/analytics', [DashboardController::class, 'analytics'])->name('dashboard.analytics');
Route::get('/api/analytics', [DashboardController::class, 'analyticsApi'])->name('api.analytics');
Route::post('/invoices/{invoice}/reinitialize', [DashboardController::class, 'reinitializeLink'])->name('invoices.reinitialize');

// Invoice routes
Route::get('/invoices', [InvoiceController::class, 'index'])->name('invoices.index');
Route::get('/invoices/create', [InvoiceController::class, 'create'])->name('invoices.create');
Route::post('/invoices', [InvoiceController::class, 'store'])->name('invoices.store');
Route::get('/invoices/{invoice}', [InvoiceController::class, 'show'])->name('invoices.show');
Route::post('/invoices/{invoice}/generate-link', [InvoiceController::class, 'generateLink'])->name('invoices.generate-link');
Route::post('/invoices/{invoice}/cancel', [InvoiceController::class, 'cancel'])->name('invoices.cancel');
Route::post('/invoices/{invoice}/complete', [InvoiceController::class, 'complete'])->name('invoices.complete');
Route::get('/invoices/{invoice}/pdf', [InvoiceController::class, 'exportPdf'])->name('invoices.pdf');

// Payment routes
Route::get('/payments', [PaymentController::class, 'index'])->name('payments.index');
Route::get('/pay/{invoice}/{token}', [PaymentController::class, 'pay'])->name('payments.pay');
Route::post('/pay/{invoice}/stk-push', [PaymentController::class, 'initiateStkPush'])->name('payments.stk-push');
Route::post('/payments/callback', [PaymentController::class, 'callback'])->name('payments.callback');
Route::post('/payments/{payment}/query-stk', [PaymentController::class, 'queryStkPush'])->name('payments.query-stk');
Route::post('/payments/{payment}/query-status', [PaymentController::class, 'queryTransactionStatus'])->name('payments.query-status');
Route::post('/payments/{payment}/reverse', [PaymentController::class, 'reverseTransaction'])->name('payments.reverse');
Route::get('/payments/{payment}/status', [PaymentController::class, 'getPaymentStatus'])->name('payments.status');
Route::get('/payments/{payment}/success', [PaymentController::class, 'showSuccess'])->name('payments.success');

// Customer routes
Route::get('/customers', [CustomerController::class, 'index'])->name('customers.index');
Route::get('/customers/{customerName}', [CustomerController::class, 'show'])->name('customers.show');
