

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-50 py-12">
    <div class="max-w-2xl mx-auto px-4">
        <!-- Success Card -->
        <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover">
            <div class="bg-gradient-to-r from-blue-600 to-indigo-600 px-8 py-8">
                <div class="text-center">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-white bg-opacity-20 rounded-full mb-4">
                        <i class="fas fa-link text-white text-4xl"></i>
                    </div>
                    <h1 class="text-3xl font-bold text-white mb-2">Payment Link Generated!</h1>
                    <p class="text-blue-100">Your secure payment link is ready to share</p>
                </div>
            </div>

            <div class="p-8">
                <!-- Link Display -->
                <div class="bg-blue-50 border border-blue-200 rounded-xl p-6 mb-8">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-share mr-2 text-blue-600"></i>Share this payment link
                    </h3>
                    <div class="bg-white border border-gray-300 rounded-lg p-4 mb-4">
                        <p class="text-sm font-mono text-gray-800 break-all"><?php echo e($link); ?></p>
                    </div>
                    <button onclick="copyToClipboard('<?php echo e($link); ?>')" class="w-full btn-primary text-white px-6 py-3 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-copy mr-2"></i>Copy Link to Clipboard
                    </button>
                </div>

                <!-- Share Options -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-8">
                    <button onclick="shareWhatsApp('<?php echo e($link); ?>')" class="btn-success text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fab fa-whatsapp mr-2 text-xl"></i>Share via WhatsApp
                    </button>
                    <button onclick="shareEmail('<?php echo e($link); ?>')" class="bg-gray-600 text-white px-6 py-4 rounded-xl hover:bg-gray-700 flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-envelope mr-2"></i>Share via Email
                    </button>
                </div>

                <!-- QR Code Option (Optional enhancement) -->
                <div class="bg-gray-50 border border-gray-200 rounded-xl p-6 mb-8">
                    <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-qrcode mr-2 text-gray-600"></i>Alternative Sharing
                    </h4>
                    <p class="text-gray-700 mb-4">You can also share the link directly or use any messaging app of your choice.</p>
                    <div class="flex items-center text-sm text-gray-600">
                        <i class="fas fa-lightbulb mr-2 text-yellow-500"></i>
                        <span>The link is secure and can only be used once for payment</span>
                    </div>
                </div>

                <!-- Actions -->
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="<?php echo e(route('invoices.show', $invoice)); ?>" class="flex-1 btn-primary text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-eye mr-2"></i>View Invoice
                    </a>
                    <a href="<?php echo e(route('dashboard')); ?>" class="flex-1 bg-gray-100 text-gray-700 px-6 py-4 rounded-xl hover:bg-gray-200 flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-tachometer-alt mr-2"></i>Back to Dashboard
                    </a>
                </div>

                <!-- Security Notice -->
                <div class="mt-8 bg-green-50 border border-green-200 rounded-xl p-4">
                    <div class="flex items-center">
                        <i class="fas fa-shield-alt text-green-600 mr-3"></i>
                        <div>
                            <p class="text-sm font-semibold text-green-800">Secure Link</p>
                            <p class="text-sm text-green-700">This payment link is encrypted and secure. It expires after successful payment.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\empower\resources\views\invoices\link-generated.blade.php ENDPATH**/ ?>