<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice <?php echo e($invoice->invoice_number); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .invoice-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .invoice-number {
            font-size: 18px;
            color: #666;
        }
        .invoice-details {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        .detail-section {
            width: 45%;
        }
        .detail-section h3 {
            margin-bottom: 10px;
            font-size: 16px;
            color: #555;
        }
        .detail-section p {
            margin: 5px 0;
            font-size: 14px;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        .items-table th,
        .items-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        .items-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .total-section {
            text-align: right;
            margin-bottom: 30px;
        }
        .total-amount {
            font-size: 20px;
            font-weight: bold;
            color: #007bff;
        }
        .notes {
            margin-top: 30px;
            padding: 15px;
            background-color: #f9f9f9;
            border-left: 4px solid #007bff;
        }
        .notes h4 {
            margin-bottom: 10px;
            color: #007bff;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 class="invoice-title"><?php echo e($invoice->business_name); ?></h1>
        <p class="invoice-number">Invoice #<?php echo e($invoice->invoice_number); ?></p>
    </div>

    <div class="invoice-details">
        <div class="detail-section">
            <h3>Bill To:</h3>
            <p><strong><?php echo e($invoice->customer_name); ?></strong></p>
            <?php if($invoice->contact_email): ?>
                <p><?php echo e($invoice->contact_email); ?></p>
            <?php endif; ?>
        </div>
        <div class="detail-section">
            <h3>Invoice Details:</h3>
            <p><strong>Date:</strong> <?php echo e($invoice->created_at->format('M d, Y')); ?></p>
            <?php if($invoice->due_date): ?>
                <p><strong>Due Date:</strong> <?php echo e($invoice->due_date->format('M d, Y')); ?></p>
            <?php endif; ?>
            <p><strong>Status:</strong> <?php echo e(ucfirst($invoice->status)); ?></p>
        </div>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th>Description</th>
                <th>Quantity</th>
                <th>Unit Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $items = json_decode($invoice->items, true);
            ?>
            <?php if(is_array($items)): ?>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($item['name']); ?></td>
                        <td><?php echo e($item['quantity']); ?></td>
                        <td>Ksh <?php echo e(number_format($item['price'], 2)); ?></td>
                        <td>Ksh <?php echo e(number_format($item['quantity'] * $item['price'], 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="total-section">
        <p><strong>Total Amount: <span class="total-amount">Ksh <?php echo e(number_format($invoice->amount, 2)); ?></span></strong></p>
    </div>

    <?php if($invoice->status == 'pending'): ?>
    <div class="payment-section" style="text-align: center; margin: 30px 0; padding: 20px; background-color: #e8f4fd; border: 1px solid #007bff; border-radius: 5px;">
        <h4 style="color: #007bff; margin-bottom: 10px;">Payment Required</h4>
        <p style="margin-bottom: 15px; color: #333;">Click the link below to make your payment securely via M-Pesa:</p>
        <p style="font-size: 16px; font-weight: bold; color: #007bff;"><?php echo e(route('payments.pay', [$invoice, $invoice->token])); ?></p>
    </div>
    <?php endif; ?>

    <?php if($invoice->description): ?>
        <div class="notes">
            <h4>Description:</h4>
            <p><?php echo e($invoice->description); ?></p>
        </div>
    <?php endif; ?>

    <?php if($invoice->notes): ?>
        <div class="notes">
            <h4>Notes:</h4>
            <p><?php echo e($invoice->notes); ?></p>
        </div>
    <?php endif; ?>

    <div class="footer">
        <p>Thank you for your business!</p>
        <p>Generated on <?php echo e(now()->format('M d, Y \a\t H:i:s')); ?></p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\empower\resources\views\invoices\pdf.blade.php ENDPATH**/ ?>