

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <!-- Invoice Header -->
    <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover mb-6">
        <div class="bg-gradient-to-r from-indigo-600 to-purple-600 px-8 py-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="bg-white bg-opacity-20 p-3 rounded-xl">
                        <i class="fas fa-file-invoice text-white text-2xl"></i>
                    </div>
                    <div class="ml-4">
                        <h1 class="text-2xl font-bold text-white">Invoice Details</h1>
                        <p class="text-indigo-100 mt-1">Invoice #<?php echo e($invoice->invoice_number); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <span class="status-badge px-4 py-2 inline-flex text-sm leading-5 font-semibold rounded-full
                        <?php if($invoice->status == 'pending'): ?> bg-yellow-100 text-yellow-800 border border-yellow-200
                        <?php elseif($invoice->status == 'paid'): ?> bg-green-100 text-green-800 border border-green-200
                        <?php elseif($invoice->status == 'cancelled'): ?> bg-red-100 text-red-800 border border-red-200
                        <?php else: ?> bg-gray-100 text-gray-800 border border-gray-200 <?php endif; ?>">
                        <i class="fas <?php if($invoice->status == 'pending'): ?> fa-clock <?php elseif($invoice->status == 'paid'): ?> fa-check-circle <?php elseif($invoice->status == 'cancelled'): ?> fa-times-circle <?php else: ?> fa-question-circle <?php endif; ?> mr-2"></i>
                        <?php echo e(ucfirst($invoice->status)); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="p-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Business & Customer Info -->
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-building mr-2 text-indigo-600"></i>Business Information
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4">
                            <p class="text-sm text-gray-600">Business Name</p>
                            <p class="text-lg font-semibold text-gray-900"><?php echo e($invoice->business_name); ?></p>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-user mr-2 text-indigo-600"></i>Customer Information
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4 space-y-3">
                            <div>
                                <p class="text-sm text-gray-600">Customer Name</p>
                                <p class="text-lg font-semibold text-gray-900"><?php echo e($invoice->customer_name); ?></p>
                            </div>
                            <?php if($invoice->contact_email): ?>
                            <div>
                                <p class="text-sm text-gray-600">Contact Email</p>
                                <p class="text-gray-900"><?php echo e($invoice->contact_email); ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Payment Details -->
                <div class="space-y-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-money-bill-wave mr-2 text-green-600"></i>Payment Details
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4 space-y-4">
                            <div>
                                <p class="text-sm text-gray-600">Description</p>
                                <p class="text-gray-900 font-medium"><?php echo e($invoice->description); ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Amount</p>
                                <p class="text-3xl font-bold text-green-600">Ksh <?php echo e(number_format($invoice->amount, 2)); ?></p>
                            </div>
                            <?php if($invoice->due_date): ?>
                            <div>
                                <p class="text-sm text-gray-600">Due Date</p>
                                <p class="text-gray-900"><?php echo e($invoice->due_date->format('M d, Y')); ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-calendar mr-2 text-indigo-600"></i>Timeline
                        </h3>
                        <div class="bg-gray-50 rounded-xl p-4">
                            <div class="flex items-center text-sm text-gray-600 mb-2">
                                <i class="fas fa-plus-circle mr-2 text-green-500"></i>
                                Created: <?php echo e($invoice->created_at->format('M d, Y H:i')); ?>

                            </div>
                            <?php if($invoice->payments->count() > 0): ?>
                            <div class="flex items-center text-sm text-gray-600">
                                <i class="fas fa-credit-card mr-2 text-blue-500"></i>
                                Last Payment: <?php echo e($invoice->payments->last()->paid_at?->format('M d, Y H:i') ?? 'N/A'); ?>

                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php if($invoice->notes): ?>
            <div class="mt-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                    <i class="fas fa-sticky-note mr-2 text-indigo-600"></i>Notes
                </h3>
                <div class="bg-blue-50 border border-blue-200 rounded-xl p-4">
                    <p class="text-gray-700"><?php echo e($invoice->notes); ?></p>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Actions Section -->
    <?php if($invoice->status == 'pending'): ?>
    <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover">
        <div class="px-8 py-6 border-b border-gray-200">
            <h3 class="text-xl leading-6 font-semibold text-gray-900 flex items-center">
                <i class="fas fa-cogs mr-3 text-indigo-600"></i>Available Actions
            </h3>
        </div>
        <div class="p-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <form method="POST" action="<?php echo e(route('invoices.generate-link', $invoice)); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full btn-success text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-link mr-2"></i>Generate Link
                    </button>
                </form>

                <form method="POST" action="<?php echo e(route('invoices.cancel', $invoice)); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full btn-danger text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200"
                            onclick="return confirm('Are you sure you want to cancel this invoice?')">
                        <i class="fas fa-times mr-2"></i>Cancel Invoice
                    </button>
                </form>

                <form method="POST" action="<?php echo e(route('invoices.complete', $invoice)); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full btn-primary text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                        <i class="fas fa-check mr-2"></i>Mark as Done
                    </button>
                </form>

                <a href="<?php echo e(route('invoices.pdf', $invoice)); ?>" class="w-full btn-primary text-white px-6 py-4 rounded-xl hover:shadow-xl flex items-center justify-center font-semibold transition-all duration-200">
                    <i class="fas fa-download mr-2"></i>Export PDF
                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Payment History -->
    <?php if($invoice->payments->count() > 0): ?>
    <div class="bg-white rounded-2xl shadow-xl border border-gray-200 overflow-hidden card-hover mt-6">
        <div class="px-8 py-6 border-b border-gray-200">
            <h3 class="text-xl leading-6 font-semibold text-gray-900 flex items-center">
                <i class="fas fa-history mr-3 text-indigo-600"></i>Payment History
            </h3>
        </div>
        <div class="p-8">
            <div class="space-y-4">
                <?php $__currentLoopData = $invoice->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl">
                    <div class="flex items-center">
                        <div class="bg-<?php echo e($payment->status == 'successful' ? 'green' : 'red'); ?>-100 p-3 rounded-lg">
                            <i class="fas fa-<?php echo e($payment->status == 'successful' ? 'check-circle' : 'times-circle'); ?> text-<?php echo e($payment->status == 'successful' ? 'green' : 'red'); ?>-600"></i>
                        </div>
                        <div class="ml-4">
                            <p class="font-semibold text-gray-900">Ksh <?php echo e(number_format($payment->amount, 2)); ?></p>
                            <p class="text-sm text-gray-600"><?php echo e($payment->phone_number); ?></p>
                            <?php if($payment->transaction_id): ?>
                            <p class="text-xs text-gray-500">Txn: <?php echo e($payment->transaction_id); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-sm text-gray-600"><?php echo e($payment->paid_at?->format('M d, Y H:i') ?? 'Pending'); ?></p>
                        <span class="px-2 py-1 text-xs font-semibold rounded-full
                            <?php if($payment->status == 'successful'): ?> bg-green-100 text-green-800
                            <?php elseif($payment->status == 'failed'): ?> bg-red-100 text-red-800
                            <?php else: ?> bg-yellow-100 text-yellow-800 <?php endif; ?>">
                            <?php echo e(ucfirst($payment->status)); ?>

                        </span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\empower\resources\views\invoices\show.blade.php ENDPATH**/ ?>