

<?php $__env->startSection('content'); ?>
<!-- Scrollspy Navigation -->
<nav class="fixed top-0 left-0 right-0 z-50 bg-white shadow-sm border-b border-gray-200">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-center space-x-8 py-3">
            <a href="#analytics" class="nav-link text-gray-600 hover:text-indigo-600 font-medium transition-colors duration-200 active" data-target="analytics">Analytics</a>
            <a href="#activity" class="nav-link text-gray-600 hover:text-indigo-600 font-medium transition-colors duration-200" data-target="activity">Activity</a>
            <a href="#invoices" class="nav-link text-gray-600 hover:text-indigo-600 font-medium transition-colors duration-200" data-target="invoices">Invoices</a>
        </div>
    </div>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const navLinks = document.querySelectorAll('.nav-link');
    const sections = document.querySelectorAll('[id]');

    function updateActiveLink() {
        const scrollPosition = window.scrollY + 100; // Offset for fixed nav

        sections.forEach(section => {
            const sectionTop = section.offsetTop;
            const sectionHeight = section.offsetHeight;
            const sectionId = section.getAttribute('id');

            if (scrollPosition >= sectionTop && scrollPosition < sectionTop + sectionHeight) {
                navLinks.forEach(link => {
                    link.classList.remove('active');
                    if (link.getAttribute('data-target') === sectionId) {
                        link.classList.add('active');
                    }
                });
            }
        });
    }

    // Smooth scrolling for nav links
    navLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const targetId = this.getAttribute('data-target');
            const targetSection = document.getElementById(targetId);
            if (targetSection) {
                window.scrollTo({
                    top: targetSection.offsetTop - 80, // Offset for fixed nav
                    behavior: 'smooth'
                });
            }
        });
    });

    // Update active link on scroll
    window.addEventListener('scroll', updateActiveLink);
    updateActiveLink(); // Initial call
});
</script>

<style>
.nav-link.active {
    color: #4f46e5;
    font-weight: 600;
}
</style>

<div class="px-4 py-6 sm:px-0 pt-20">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-900 mb-2">Dashboard</h1>
            <p class="text-gray-600">Manage your invoices and payments</p>
        </div>
        <a href="<?php echo e(route('invoices.create')); ?>" class="btn-primary text-white px-8 py-3 rounded-xl hover:shadow-xl flex items-center font-semibold">
            <i class="fas fa-plus mr-2"></i>Create New Invoice
        </a>
    </div>

    <!-- Analytics Cards -->
    <div id="analytics" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-blue-100 text-sm font-medium">Total Invoices</p>
                    <p class="text-3xl font-bold"><?php echo e($invoices->count()); ?></p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-file-invoice text-2xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-blue-100 text-sm">All time</span>
            </div>
        </div>

        <div class="bg-gradient-to-r from-green-500 to-green-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-green-100 text-sm font-medium">Total Paid</p>
                    <p class="text-3xl font-bold">Ksh <?php echo e(number_format($invoices->where('status', 'paid')->sum('amount'), 2)); ?></p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-check-circle text-2xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-green-100 text-sm"><?php echo e($invoices->where('status', 'paid')->count()); ?> invoices</span>
            </div>
        </div>

        <div class="bg-gradient-to-r from-yellow-500 to-yellow-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-yellow-100 text-sm font-medium">Pending Amount</p>
                    <p class="text-3xl font-bold">Ksh <?php echo e(number_format($invoices->where('status', 'pending')->sum('amount'), 2)); ?></p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-clock text-2xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-yellow-100 text-sm"><?php echo e($invoices->where('status', 'pending')->count()); ?> pending</span>
            </div>
        </div>

        <div class="bg-gradient-to-r from-purple-500 to-purple-600 rounded-xl shadow-lg p-6 text-white card-hover">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-purple-100 text-sm font-medium">Success Rate</p>
                    <p class="text-3xl font-bold">
                        <?php if($invoices->count() > 0): ?>
                            <?php echo e(round(($invoices->where('status', 'paid')->count() / $invoices->count()) * 100)); ?>%
                        <?php else: ?>
                            0%
                        <?php endif; ?>
                    </p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-lg">
                    <i class="fas fa-chart-line text-2xl"></i>
                </div>
            </div>
            <div class="mt-4">
                <span class="text-purple-100 text-sm">Payment success</span>
            </div>
        </div>
    </div>

    <!-- Recent Activity & Quick Stats -->
    <div id="activity" class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
        <!-- Recent Payments -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 card-hover">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-history mr-2 text-green-600"></i>Recent Payments
                </h3>
            </div>
            <div class="p-6 max-h-60 overflow-y-scroll">
                <?php if($recentPayments->count() > 0): ?>
                    <?php $__currentLoopData = $recentPayments->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between py-3 border-b border-gray-100 last:border-b-0">
                        <div class="flex items-center">
                            <div class="bg-green-100 p-2 rounded-lg">
                                <i class="fas fa-check text-green-600"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-gray-900"><?php echo e($invoice->customer_name); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($invoice->invoice_number); ?></p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-semibold text-gray-900">Ksh <?php echo e(number_format($invoice->amount, 2)); ?></p>
                            <p class="text-xs text-gray-500"><?php echo e($invoice->updated_at->diffForHumans()); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="text-center py-8">
                        <i class="fas fa-inbox text-3xl text-gray-300 mb-2"></i>
                        <p class="text-gray-500 text-sm">No payments yet</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Pending Invoices -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 card-hover">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-clock mr-2 text-yellow-600"></i>Pending Invoices
                </h3>
            </div>
            <div class="p-6 max-h-80 overflow-y-scroll">
                <?php if($pendingInvoices->count() > 0): ?>
                    <?php $__currentLoopData = $pendingInvoices->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between py-3 border-b border-gray-100 last:border-b-0">
                        <div class="flex items-center">
                            <div class="bg-yellow-100 p-2 rounded-lg">
                                <i class="fas fa-clock text-yellow-600"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-gray-900"><?php echo e($invoice->customer_name); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($invoice->invoice_number); ?></p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-semibold text-gray-900">Ksh <?php echo e(number_format($invoice->amount, 2)); ?></p>
                            <p class="text-xs text-gray-500"><?php echo e($invoice->created_at->diffForHumans()); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="text-center py-8">
                        <i class="fas fa-check-circle text-3xl text-gray-300 mb-2"></i>
                        <p class="text-gray-500 text-sm">All caught up!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 card-hover">
            <div class="px-6 py-5 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-bolt mr-2 text-indigo-600"></i>Quick Actions
                </h3>
            </div>
            <div class="p-6 space-y-3">
                <a href="<?php echo e(route('invoices.create')); ?>" class="w-full btn-primary text-white px-4 py-3 rounded-lg hover:shadow-lg flex items-center justify-center font-semibold transition-all duration-200">
                    <i class="fas fa-plus mr-2"></i>New Invoice
                </a>
                <a href="<?php echo e(route('dashboard.export')); ?>" class="w-full bg-gray-100 text-gray-700 px-4 py-3 rounded-lg hover:bg-gray-200 flex items-center justify-center font-semibold transition-all duration-200">
                    <i class="fas fa-download mr-2"></i>Export Data
                </a>
                <a href="<?php echo e(route('dashboard.analytics')); ?>" class="w-full bg-purple-100 text-purple-700 px-4 py-3 rounded-lg hover:bg-purple-200 flex items-center justify-center font-semibold transition-all duration-200">
                    <i class="fas fa-chart-bar mr-2"></i>View Analytics
                </a>
            </div>
        </div>
    </div>

    <!-- Invoices Table -->
    <div id="invoices" class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-xl card-hover">
        <div class="px-6 py-5 border-b border-gray-200">
            <h3 class="text-xl leading-6 font-semibold text-gray-900 flex items-center">
                <i class="fas fa-list mr-3 text-indigo-600"></i>All Invoices
            </h3>
        </div>
        <div class="px-6 py-6">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Invoice #</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Customer</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Amount</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 transition-colors duration-200">
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900"><?php echo e($invoice->invoice_number); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                <div class="flex items-center">
                                    <i class="fas fa-user mr-2 text-gray-400"></i>
                                    <?php echo e($invoice->customer_name); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900">
                                <div class="flex items-center">
                                    <i class="fas fa-money-bill-wave mr-2 text-green-500"></i>
                                    Ksh <?php echo e(number_format($invoice->amount, 2)); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="status-badge px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full
                                    <?php if($invoice->status == 'pending'): ?> bg-yellow-100 text-yellow-800 border border-yellow-200
                                    <?php elseif($invoice->status == 'paid'): ?> bg-green-100 text-green-800 border border-green-200
                                    <?php elseif($invoice->status == 'cancelled'): ?> bg-red-100 text-red-800 border border-red-200
                                    <?php else: ?> bg-gray-100 text-gray-800 border border-gray-200 <?php endif; ?>">
                                    <i class="fas <?php if($invoice->status == 'pending'): ?> fa-clock <?php elseif($invoice->status == 'paid'): ?> fa-check-circle <?php elseif($invoice->status == 'cancelled'): ?> fa-times-circle <?php else: ?> fa-question-circle <?php endif; ?> mr-1"></i>
                                    <?php echo e(ucfirst($invoice->status)); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                <div class="flex items-center">
                                    <i class="fas fa-calendar mr-2 text-gray-400"></i>
                                    <?php echo e($invoice->created_at->format('M d, Y')); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex items-center space-x-3">
                                    <a href="<?php echo e(route('invoices.show', $invoice)); ?>" class="text-indigo-600 hover:text-indigo-900 transition-colors duration-200 flex items-center">
                                        <i class="fas fa-eye mr-1"></i>View
                                    </a>
                                    <?php if($invoice->status == 'pending'): ?>
                                    <form method="POST" action="<?php echo e(route('invoices.reinitialize', $invoice)); ?>" class="inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="text-blue-600 hover:text-blue-900 transition-colors duration-200 flex items-center">
                                            <i class="fas fa-redo mr-1"></i>Reinitialize
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                                    <h3 class="text-lg font-medium text-gray-900 mb-2">No invoices found</h3>
                                    <p class="text-gray-500 mb-4">Get started by creating your first invoice.</p>
                                    <a href="<?php echo e(route('invoices.create')); ?>" class="btn-primary text-white px-6 py-2 rounded-lg hover:shadow-lg flex items-center">
                                        <i class="fas fa-plus mr-2"></i>Create Invoice
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                <?php echo e($invoices->links()); ?>

            </div>
        </div>
    </div>
</div>


</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\empower\resources\views\dashboard.blade.php ENDPATH**/ ?>