<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoices Export Report</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #2563eb;
            padding-bottom: 20px;
        }
        .header h1 {
            color: #2563eb;
            margin: 0;
            font-size: 24px;
        }
        .header p {
            color: #6b7280;
            margin: 5px 0 0 0;
            font-size: 14px;
        }
        .summary {
            display: table;
            width: 100%;
            margin-bottom: 30px;
            border-collapse: collapse;
        }
        .summary-row {
            display: table-row;
        }
        .summary-cell {
            display: table-cell;
            padding: 15px;
            border: 1px solid #e5e7eb;
            text-align: center;
            background: #f9fafb;
        }
        .summary-cell h3 {
            margin: 0;
            font-size: 18px;
            color: #2563eb;
        }
        .summary-cell p {
            margin: 5px 0 0 0;
            color: #6b7280;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #e5e7eb;
            padding: 12px;
            text-align: left;
            font-size: 12px;
        }
        th {
            background-color: #f3f4f6;
            font-weight: bold;
            color: #374151;
        }
        tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .status-paid {
            color: #059669;
            font-weight: bold;
        }
        .status-pending {
            color: #d97706;
            font-weight: bold;
        }
        .status-cancelled {
            color: #dc2626;
            font-weight: bold;
        }
        .amount {
            font-weight: bold;
            color: #059669;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #9ca3af;
            border-top: 1px solid #e5e7eb;
            padding-top: 20px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Invoices Export Report</h1>
        <p>Generated on <?php echo e(now()->format('F j, Y \a\t H:i:s')); ?></p>
    </div>

    <!-- Summary Section -->
    <div class="summary">
        <div class="summary-row">
            <div class="summary-cell">
                <h3><?php echo e($invoices->count()); ?></h3>
                <p>Total Invoices</p>
            </div>
            <div class="summary-cell">
                <h3><?php echo e($invoices->where('status', 'paid')->count()); ?></h3>
                <p>Paid Invoices</p>
            </div>
            <div class="summary-cell">
                <h3><?php echo e($invoices->where('status', 'pending')->count()); ?></h3>
                <p>Pending Invoices</p>
            </div>
            <div class="summary-cell">
                <h3>Ksh <?php echo e(number_format($invoices->where('status', 'paid')->sum('amount'), 2)); ?></h3>
                <p>Total Revenue</p>
            </div>
        </div>
    </div>

    <!-- Invoices Table -->
    <table>
        <thead>
            <tr>
                <th>Invoice #</th>
                <th>Customer Name</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Created Date</th>
                <th>Paid Date</th>
                <th>M-Pesa Receipt</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($invoice->invoice_number); ?></td>
                <td><?php echo e($invoice->customer_name); ?></td>
                <td class="amount">Ksh <?php echo e(number_format($invoice->amount, 2)); ?></td>
                <td class="status-<?php echo e($invoice->status); ?>">
                    <?php echo e(ucfirst($invoice->status)); ?>

                </td>
                <td><?php echo e($invoice->created_at->format('M d, Y H:i:s')); ?></td>
                <td>
                    <?php
                        $paidDate = $invoice->payments->where('status', 'successful')->first()?->paid_at?->format('M d, Y H:i:s') ?? '';
                    ?>
                    <?php echo e($paidDate ?: '-'); ?>

                </td>
                <td>
                    <?php
                        $receiptNumber = $invoice->payments->where('status', 'successful')->first()?->receipt_number ?? '';
                    ?>
                    <?php echo e($receiptNumber ?: '-'); ?>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p>This report was generated automatically by the Invoice Management System</p>
        <p>Report contains <?php echo e($invoices->count()); ?> invoice records</p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\empower\resources\views\dashboard\export-pdf.blade.php ENDPATH**/ ?>